/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.pdfboxout;

import com.openhtmltopdf.util.XRLog;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.Locale;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.util.Matrix;

public class PdfContentStreamAdapter {
    private final PDPageContentStream cs;

    private void logAndThrow(String method, IOException e) {
        XRLog.exception((String)("Exception in PDF writing method: " + method), (Throwable)e);
        throw new PdfException(method, e);
    }

    public PdfContentStreamAdapter(PDPageContentStream cs) {
        this.cs = cs;
    }

    public void fillRect(float x, float y, float w, float h) {
        try {
            this.cs.addRect(x, y, w, h);
            this.cs.fill();
        }
        catch (IOException e) {
            this.logAndThrow("fillRect", e);
        }
    }

    public void addRect(float x, float y, float w, float h) {
        try {
            this.cs.addRect(x, y, w, h);
        }
        catch (IOException e) {
            this.logAndThrow("addRect", e);
        }
    }

    public void newPath() {
    }

    public void setExtGState(PDExtendedGraphicsState gs) {
        try {
            this.cs.setGraphicsStateParameters(gs);
        }
        catch (IOException e) {
            this.logAndThrow("setExtGState", e);
        }
    }

    public void closeSubpath() {
        try {
            this.cs.closePath();
        }
        catch (IOException e) {
            this.logAndThrow("closeSubpath", e);
        }
    }

    public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        try {
            this.cs.curveTo(x1, y1, x2, y2, x3, y3);
        }
        catch (IOException e) {
            this.logAndThrow("curveTo(6)", e);
        }
    }

    public void curveTo(float x1, float y1, float x3, float y3) {
        try {
            this.cs.curveTo1(x1, y1, x3, y3);
        }
        catch (IOException e) {
            this.logAndThrow("curveTo(4)", e);
        }
    }

    public void closeContent() {
        try {
            this.cs.close();
        }
        catch (IOException e) {
            this.logAndThrow("closeContent", e);
        }
    }

    public void lineTo(float x1, float y1) {
        try {
            this.cs.lineTo(x1, y1);
        }
        catch (IOException e) {
            this.logAndThrow("lineTo", e);
        }
    }

    public void moveTo(float x1, float y1) {
        try {
            this.cs.moveTo(x1, y1);
        }
        catch (IOException e) {
            this.logAndThrow("moveTo", e);
        }
    }

    public void fillEvenOdd() {
        try {
            this.cs.fillEvenOdd();
        }
        catch (IOException e) {
            this.logAndThrow("fillEvenOdd", e);
        }
    }

    public void fillNonZero() {
        try {
            this.cs.fill();
        }
        catch (IOException e) {
            this.logAndThrow("fillNonZero", e);
        }
    }

    public void stroke() {
        try {
            this.cs.stroke();
        }
        catch (IOException e) {
            this.logAndThrow("stroke", e);
        }
    }

    public void clipNonZero() {
        try {
            this.cs.clip();
        }
        catch (IOException e) {
            this.logAndThrow("clipNonZero", e);
        }
    }

    public void clipEvenOdd() {
        try {
            this.cs.clipEvenOdd();
        }
        catch (IOException e) {
            this.logAndThrow("clipEvenOdd", e);
        }
    }

    public void setStrokingColor(int r, int g, int b) {
        try {
            this.cs.setStrokingColor(r, g, b);
        }
        catch (IOException e) {
            this.logAndThrow("setStrokingColor", e);
        }
    }

    public void setStrokingColor(float c, float m, float y, float k) {
        try {
            this.cs.setStrokingColor(c, m, y, k);
        }
        catch (IOException e) {
            this.logAndThrow("setStrokingColor(CMYK)", e);
        }
    }

    public void setFillColor(int r, int g, int b) {
        try {
            this.cs.setNonStrokingColor(r, g, b);
        }
        catch (IOException e) {
            this.logAndThrow("setFillColor", e);
        }
    }

    public void setFillColor(float c, float m, float y, float k) {
        try {
            this.cs.setNonStrokingColor((double)c, (double)m, (double)y, (double)k);
        }
        catch (IOException e) {
            this.logAndThrow("setFillColor(CMYK)", e);
        }
    }

    public void setLineWidth(float width) {
        try {
            this.cs.setLineWidth(width);
        }
        catch (IOException e) {
            this.logAndThrow("setLineWidth", e);
        }
    }

    public void setLineCap(int capStyle) {
        try {
            this.cs.setLineCapStyle(capStyle);
        }
        catch (IOException e) {
            this.logAndThrow("setLineCap", e);
        }
    }

    public void setLineJoin(int joinStyle) {
        try {
            this.cs.setLineJoinStyle(joinStyle);
        }
        catch (IOException e) {
            this.logAndThrow("setLineJoin", e);
        }
    }

    public void setLineDash(float[] dash, float phase) {
        try {
            this.cs.setLineDashPattern(dash, phase);
        }
        catch (IOException e) {
            this.logAndThrow("setLineDash", e);
        }
    }

    public void restoreGraphics() {
        try {
            this.cs.restoreGraphicsState();
        }
        catch (IOException e) {
            this.logAndThrow("restoreGraphics", e);
        }
    }

    public void saveGraphics() {
        try {
            this.cs.saveGraphicsState();
        }
        catch (IOException e) {
            this.logAndThrow("saveGraphics", e);
        }
    }

    public void beginText() {
        try {
            this.cs.beginText();
        }
        catch (IOException e) {
            this.logAndThrow("beginText", e);
        }
    }

    public void endText() {
        try {
            this.cs.endText();
        }
        catch (IOException e) {
            this.logAndThrow("endText", e);
        }
    }

    public void setFont(PDFont font, float size) {
        try {
            this.cs.setFont(font, size);
        }
        catch (IOException e) {
            this.logAndThrow("setFont", e);
        }
    }

    public void setTextMatrix(float a, float b, float c, float d, float e, float f) {
        try {
            Matrix mtrx = new Matrix(a, b, c, d, e, f);
            this.cs.setTextMatrix(mtrx);
        }
        catch (IOException e1) {
            this.logAndThrow("setTextMatrix", e1);
        }
    }

    public void drawString(String s) {
        try {
            this.cs.showText(s);
        }
        catch (IOException e) {
            this.logAndThrow("drawString", e);
        }
    }

    public void drawImage(PDImageXObject xobject, float x, float y, float w, float h) {
        try {
            this.cs.drawImage(xobject, x, y, w, h);
        }
        catch (IOException e) {
            this.logAndThrow("drawImage", e);
        }
    }

    public void setMiterLimit(float miterLimit) {
    }

    public void setTextSpacing(float nonSpaceAdjust) {
        try {
            this.cs.appendRawCommands(String.format(Locale.US, "%.4f Tc\n", Float.valueOf(nonSpaceAdjust)));
        }
        catch (IOException e) {
            this.logAndThrow("setSpaceSpacing", e);
        }
    }

    public void setSpaceSpacing(float spaceAdjust) {
        try {
            this.cs.appendRawCommands(String.format(Locale.US, "%.4f Tw\n", Float.valueOf(spaceAdjust)));
        }
        catch (IOException e) {
            this.logAndThrow("setSpaceSpacing", e);
        }
    }

    public void setPdfMatrix(AffineTransform transform) {
        try {
            this.cs.transform(new Matrix(transform));
        }
        catch (IOException e) {
            this.logAndThrow("setPdfMatrix", e);
        }
    }

    public static class PdfException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public PdfException(String method, Exception cause) {
            super(method, cause);
        }
    }
}

