/*
 * Decompiled with CFR 0.152.
 */
package com.lochbridge.oath.otp.keyprovisioning;

import com.google.common.base.Preconditions;

public final class OTPKey {
    private final String key;
    private final OTPType type;

    public OTPKey(String key, OTPType type) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)((Object)type));
        this.key = key;
        this.type = type;
    }

    public String getKey() {
        return this.key;
    }

    public OTPType getType() {
        return this.type;
    }

    public static enum OTPType {
        HOTP("HOTP"),
        TOTP("TOTP");

        private final String name;

        private OTPType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static OTPType from(String name) {
            for (OTPType type : OTPType.values()) {
                if (!type.name.equals(name)) continue;
                return type;
            }
            throw new IllegalArgumentException("No matching OTPType constant for [" + name + "]");
        }

        public String toString() {
            return this.name;
        }
    }
}

