/*
 * Decompiled with CFR 0.152.
 */
package com.lochbridge.oath.otp.keyprovisioning;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Range;
import com.lochbridge.oath.otp.TOTPBuilder;
import com.lochbridge.oath.otp.keyprovisioning.OTPAuthURI;
import com.lochbridge.oath.otp.keyprovisioning.OTPKey;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OTPAuthURIBuilder {
    private static final String SCHEME_PATTERN = "(otpauth)";
    private static final String OTP_TYPE_PATTERN = "(hotp|totp)";
    private static final String LABEL_PATTERN = "([^?#]*)";
    private static final String QUERY_PATTERN = "([^#]*)";
    private static final Pattern OTP_AUTH_URI_PATTERN = Pattern.compile("(otpauth)://(hotp|totp)/([^?#]*)\\?([^#]*)");
    private final OTPKey key;
    private String label;
    private String labelIssuerPrefix;
    private String issuer;
    private long counter = 0L;
    private int digits;
    private long timeStep = TOTPBuilder.DEFAULT_TIME_STEP;

    private OTPAuthURIBuilder(OTPKey key) {
        this.key = key;
        this.digits = key.getType().equals((Object)OTPKey.OTPType.HOTP) ? 6 : 6;
    }

    public static OTPAuthURIBuilder fromKey(OTPKey key) {
        return new OTPAuthURIBuilder(key);
    }

    public static OTPAuthURIBuilder fromUriString(String uri) {
        Preconditions.checkNotNull((Object)uri);
        Matcher m = OTP_AUTH_URI_PATTERN.matcher(uri);
        if (!m.matches()) {
            throw new IllegalArgumentException("[" + uri + "] is not a valid OTP Auth URI");
        }
        OTPKey.OTPType otpType = OTPKey.OTPType.from(m.group(2).toUpperCase(Locale.US));
        String label = null;
        try {
            label = new URI(uri).getPath().substring(1);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        if (Strings.nullToEmpty((String)label).trim().isEmpty()) {
            throw new IllegalArgumentException("[" + uri + "] is not a valid otp auth URI: 'label' component is missing!");
        }
        String secret = null;
        String issuer = null;
        Integer digits = null;
        Long counter = null;
        Long period = null;
        String query = m.group(4);
        Map decoder = Splitter.on((char)'&').withKeyValueSeparator("=").split((CharSequence)query);
        for (Map.Entry queryParam : decoder.entrySet()) {
            if ("secret".equals(queryParam.getKey())) {
                secret = (String)queryParam.getValue();
                if (!Strings.nullToEmpty((String)secret).trim().isEmpty()) continue;
                throw new IllegalArgumentException("[" + uri + "] is not a valid otp auth URI: 'secret' parameter value is missing!");
            }
            if ("issuer".equals(queryParam.getKey())) {
                if (Strings.nullToEmpty((String)((String)queryParam.getValue())).trim().isEmpty()) {
                    throw new IllegalArgumentException("[" + uri + "] is not a valid otp auth URI: 'issuer' parameter value is missing!");
                }
                try {
                    issuer = URLDecoder.decode((String)queryParam.getValue(), StandardCharsets.UTF_8.name());
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("Unexpected error - underlying platform does not support UTF-8 charset!", e);
                }
            }
            if ("digits".equals(queryParam.getKey())) {
                if (Strings.nullToEmpty((String)((String)queryParam.getValue())).trim().isEmpty()) {
                    throw new IllegalArgumentException("[" + uri + "] is not a valid otp auth URI: 'digits' parameter value is missing!");
                }
                digits = Integer.valueOf((String)queryParam.getValue());
                continue;
            }
            if ("counter".equals(queryParam.getKey())) {
                if (!otpType.equals((Object)OTPKey.OTPType.HOTP)) {
                    throw new IllegalArgumentException("[" + uri + "] is not a valid otp auth URI: 'counter' is not a valid totp parameter!");
                }
                if (Strings.nullToEmpty((String)((String)queryParam.getValue())).trim().isEmpty()) {
                    throw new IllegalArgumentException("[" + uri + "] is not a valid otp auth URI: 'counter' parameter value is missing!");
                }
                counter = Long.valueOf((String)queryParam.getValue());
                continue;
            }
            if ("period".equals(queryParam.getKey())) {
                if (!otpType.equals((Object)OTPKey.OTPType.TOTP)) {
                    throw new IllegalArgumentException("[" + uri + "] is not a valid otp auth URI: 'period' is not a valid hotp parameter!");
                }
                if (Strings.nullToEmpty((String)((String)queryParam.getValue())).trim().isEmpty()) {
                    throw new IllegalArgumentException("[" + uri + "] is not a valid otp auth URI: 'period' parameter value is missing!");
                }
                period = Long.valueOf((String)queryParam.getValue());
                continue;
            }
            throw new IllegalArgumentException("[" + uri + "] is not a valid otp auth URI: '" + (String)queryParam.getKey() + "' is not a supported parameter!");
        }
        if (secret == null) {
            throw new IllegalArgumentException("[" + uri + "] is not a valid otp auth URI: 'secret' parameter is missing!");
        }
        if (digits == null) {
            throw new IllegalArgumentException("[" + uri + "] is not a valid otp auth URI: 'digits' parameter is missing!");
        }
        if (otpType.equals((Object)OTPKey.OTPType.HOTP) && counter == null) {
            throw new IllegalArgumentException("[" + uri + "] is not a valid otp auth URI: 'counter' parameter is missing!");
        }
        if (otpType.equals((Object)OTPKey.OTPType.TOTP) && period == null) {
            throw new IllegalArgumentException("[" + uri + "] is not a valid otp auth URI: 'period' parameter is missing!");
        }
        OTPAuthURIBuilder builder = new OTPAuthURIBuilder(new OTPKey(secret, otpType)).label(label).issuer(issuer).digits(digits);
        if (counter != null) {
            builder.counter(counter);
        }
        if (period != null) {
            builder.timeStep(TimeUnit.SECONDS.toMillis(period));
        }
        return builder;
    }

    public OTPAuthURIBuilder label(String label) {
        String issuerPrefix;
        Preconditions.checkNotNull((Object)label);
        int index = label.indexOf(":");
        String string = issuerPrefix = index > 0 ? label.substring(0, index) : null;
        if (issuerPrefix == null) {
            Preconditions.checkArgument((!label.trim().isEmpty() ? 1 : 0) != 0, (Object)"The label's account name is missing or empty!");
            Preconditions.checkArgument((!label.contains(":") ? 1 : 0) != 0, (Object)"The 'label' cannot contain any ':' characters other than the separator between the issuer prefix and account name!");
        } else {
            Preconditions.checkArgument((!issuerPrefix.trim().isEmpty() ? 1 : 0) != 0, (Object)"The label's issuer prefix is empty!");
            String accountName = label.substring(index + 1);
            Preconditions.checkArgument((!accountName.trim().isEmpty() ? 1 : 0) != 0, (Object)"The label's account name is missing or empty!");
            Preconditions.checkArgument((!accountName.contains(":") ? 1 : 0) != 0, (Object)"The label's account name cannot contain any ':' characters!");
        }
        this.label = label;
        this.labelIssuerPrefix = issuerPrefix;
        return this;
    }

    public OTPAuthURIBuilder issuer(String issuer) {
        if (issuer != null) {
            Preconditions.checkArgument((!issuer.contains(":") ? 1 : 0) != 0, (Object)"The issuer cannot contain a colon!");
        }
        this.issuer = issuer;
        return this;
    }

    public OTPAuthURIBuilder digits(int digits) {
        if (this.key.getType().equals((Object)OTPKey.OTPType.HOTP)) {
            Preconditions.checkArgument((boolean)Range.closed((Comparable)Integer.valueOf(6), (Comparable)Integer.valueOf(8)).contains((Comparable)Integer.valueOf(digits)));
        } else {
            Preconditions.checkArgument((boolean)Range.closed((Comparable)Integer.valueOf(6), (Comparable)Integer.valueOf(8)).contains((Comparable)Integer.valueOf(digits)));
        }
        this.digits = digits;
        return this;
    }

    public OTPAuthURIBuilder counter(long counter) {
        Preconditions.checkArgument((counter >= 0L ? 1 : 0) != 0);
        this.counter = counter;
        return this;
    }

    public OTPAuthURIBuilder timeStep(long timeStep) {
        Preconditions.checkArgument((timeStep > 0L ? 1 : 0) != 0);
        this.timeStep = timeStep;
        return this;
    }

    public OTPAuthURI build() {
        Preconditions.checkState((this.label != null ? 1 : 0) != 0, (Object)"The label has not been configured!");
        if (this.issuer != null && this.labelIssuerPrefix != null) {
            Preconditions.checkState((boolean)this.issuer.equals(this.labelIssuerPrefix), (Object)"The 'issuer' and label issuer prefix values are different!");
        }
        return new OTPAuthURI(this.key, this.issuer, this.label, this.counter, this.digits, TimeUnit.MILLISECONDS.toSeconds(this.timeStep));
    }
}

