/*
 * Decompiled with CFR 0.152.
 */
package com.lochbridge.oath.otp.keyprovisioning;

import com.google.common.base.Preconditions;
import com.google.common.escape.Escaper;
import com.google.common.net.PercentEscaper;
import com.google.common.net.UrlEscapers;
import com.lochbridge.oath.otp.keyprovisioning.OTPKey;
import java.util.Locale;

public class OTPAuthURI {
    private static final String URI_SAFECHARS_QUERY_STRING = "-._~!$'()*,;:@/?";
    private static final Escaper QUERY_STRING_ESCAPER_NO_PLUS = new PercentEscaper("-._~!$'()*,;:@/?", false);
    private final OTPKey key;
    private final String issuer;
    private final String label;
    private final long counter;
    private final int digits;
    private final long timeStep;

    OTPAuthURI(OTPKey key, String issuer, String label, long counter, int digits, long timeStep) {
        this.key = key;
        this.issuer = issuer;
        this.label = label;
        this.counter = counter;
        this.digits = digits;
        this.timeStep = timeStep;
    }

    public OTPKey getKey() {
        return this.key;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getEncodedIssuer() {
        return this.issuer == null ? null : OTPAuthURI.safeEncodeIssuer(this.issuer);
    }

    public String getLabel() {
        return this.label;
    }

    public String getEncodedLabel() {
        return OTPAuthURI.safeEncodeLabel(this.label);
    }

    public long getCounter() {
        return this.counter;
    }

    public int getDigits() {
        return this.digits;
    }

    public long getTimeStep() {
        return this.timeStep;
    }

    public boolean isHOTP() {
        return this.key.getType().equals((Object)OTPKey.OTPType.HOTP);
    }

    public boolean isTOTP() {
        return this.key.getType().equals((Object)OTPKey.OTPType.TOTP);
    }

    private String contstructUriString(boolean ignoreEncodeSettings) {
        StringBuilder sb = new StringBuilder();
        sb.append("otpauth://");
        sb.append(this.key.getType().getName().toLowerCase(Locale.US));
        sb.append("/");
        sb.append(ignoreEncodeSettings ? this.label : OTPAuthURI.safeEncodeLabel(this.label));
        sb.append("?secret=");
        sb.append(this.key.getKey());
        if (this.issuer != null) {
            sb.append("&issuer=");
            sb.append(ignoreEncodeSettings ? this.issuer : OTPAuthURI.safeEncodeIssuer(this.issuer));
        }
        sb.append("&digits=");
        sb.append(this.digits);
        if (this.isHOTP()) {
            sb.append("&counter=");
            sb.append(this.counter);
        }
        if (this.isTOTP()) {
            sb.append("&period=");
            sb.append(this.timeStep);
        }
        return sb.toString();
    }

    public String toPlainTextUriString() {
        return this.contstructUriString(true);
    }

    public String toUriString() {
        return this.contstructUriString(false);
    }

    public static final String encodeLabel(String label) {
        Preconditions.checkNotNull((Object)label);
        return OTPAuthURI.safeEncodeLabel(label);
    }

    private static final String safeEncodeLabel(String label) {
        return UrlEscapers.urlPathSegmentEscaper().escape(label);
    }

    public static final String encodeIssuer(String issuer) {
        Preconditions.checkNotNull((Object)issuer);
        return OTPAuthURI.safeEncodeIssuer(issuer);
    }

    private static final String safeEncodeIssuer(String issuer) {
        return QUERY_STRING_ESCAPER_NO_PLUS.escape(issuer);
    }
}

