/*
 * Decompiled with CFR 0.152.
 */
package com.lightstep.tracer.shared;

import com.google.protobuf.Timestamp;
import java.math.BigInteger;
import java.util.Random;

class Util {
    private static ThreadLocal<Random> random = new ThreadLocal<Random>(){

        @Override
        protected Random initialValue() {
            return new Random(System.currentTimeMillis() * (System.nanoTime() % 1000000L) * Thread.currentThread().getId() * (long)(1024.0 * Math.random()));
        }
    };

    Util() {
    }

    static long generateRandomGUID() {
        return random.get().nextLong();
    }

    static long protoTimeToEpochMicros(Timestamp timestamp) {
        return timestamp.getSeconds() * 1000000L + (long)(timestamp.getNanos() / 1000);
    }

    static Timestamp epochTimeMicrosToProtoTime(long micros) {
        Timestamp.Builder builder = Timestamp.newBuilder();
        builder.setSeconds(micros / 1000000L);
        builder.setNanos((int)(micros % 1000000L) * 1000);
        return builder.build();
    }

    static int safeLongToInt(long l) throws IllegalArgumentException {
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(l + " cannot be cast to an int without changing its value.");
        }
        return (int)l;
    }

    static long nowMicrosApproximate() {
        return System.currentTimeMillis() * 1000L;
    }

    static long fromHexString(String hexString) {
        return new BigInteger(hexString, 16).longValue();
    }

    static String toHexString(long l) {
        return Long.toHexString(l);
    }
}

