/*
 * Decompiled with CFR 0.152.
 */
package com.lightstep.tracer.shared;

import com.lightstep.tracer.shared.Propagator;
import com.lightstep.tracer.shared.SpanContext;
import com.lightstep.tracer.shared.Util;
import io.opentracing.propagation.TextMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

class TextMapPropagator
implements Propagator<TextMap> {
    private static final Locale english = new Locale("en", "US");
    private static final String PREFIX_TRACER_STATE = "ot-tracer-";
    static final String PREFIX_BAGGAGE = "ot-baggage-";
    static final String FIELD_NAME_TRACE_ID = "ot-tracer-traceid";
    static final String FIELD_NAME_SPAN_ID = "ot-tracer-spanid";
    static final String FIELD_NAME_SAMPLED = "ot-tracer-sampled";

    TextMapPropagator() {
    }

    @Override
    public void inject(SpanContext spanContext, TextMap carrier) {
        carrier.put(FIELD_NAME_TRACE_ID, Util.toHexString(spanContext.getTraceId()));
        carrier.put(FIELD_NAME_SPAN_ID, Util.toHexString(spanContext.getSpanId()));
        carrier.put(FIELD_NAME_SAMPLED, "true");
        for (Map.Entry<String, String> e : spanContext.baggageItems()) {
            carrier.put(PREFIX_BAGGAGE + e.getKey(), e.getValue());
        }
    }

    @Override
    public SpanContext extract(TextMap carrier) {
        Long traceId = null;
        Long spanId = null;
        HashMap<String, String> baggage = new HashMap<String, String>();
        for (Map.Entry entry : carrier) {
            String key = ((String)entry.getKey()).toLowerCase(english);
            if (FIELD_NAME_TRACE_ID.equals(key)) {
                traceId = Util.fromHexString((String)entry.getValue());
            }
            if (FIELD_NAME_SPAN_ID.equals(key)) {
                spanId = Util.fromHexString((String)entry.getValue());
            }
            if (!key.startsWith(PREFIX_BAGGAGE)) continue;
            baggage.put(key.substring(PREFIX_BAGGAGE.length()), (String)entry.getValue());
        }
        if (traceId == null || spanId == null) {
            return null;
        }
        return new SpanContext(traceId, spanId, baggage);
    }
}

