/*
 * Decompiled with CFR 0.152.
 */
package com.lightstep.tracer.shared;

import com.lightstep.tracer.shared.Util;
import io.opentracing.ScopeManager;
import io.opentracing.util.ThreadLocalScopeManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public final class Options {
    private static final String COMPONENT_NAME_SYSTEM_PROPERTY_KEY = "sun.java.command";
    private static final String DEFAULT_COLLECTOR_HOST = "collector-grpc.lightstep.com";
    static final int DEFAULT_SECURE_PORT = 443;
    static final int DEFAULT_PLAINTEXT_PORT = 80;
    public static final int DEFAULT_MAX_BUFFERED_SPANS = 1000;
    private static final long DEFAULT_REPORTING_INTERVAL_MILLIS = 3000L;
    private static final long DEFAULT_DEADLINE_MILLIS = 30000L;
    static final String HTTPS = "https";
    static final String HTTP = "http";
    static final String COLLECTOR_PATH = "/api/v2/reports";
    static final String LEGACY_COMPONENT_NAME_KEY = "component_name";
    static final String COMPONENT_NAME_KEY = "lightstep.component_name";
    static final String GUID_KEY = "lightstep.guid";
    public static final int VERBOSITY_DEBUG = 4;
    public static final int VERBOSITY_INFO = 3;
    public static final int VERBOSITY_ERRORS_ONLY = 2;
    public static final int VERBOSITY_FIRST_ERROR_ONLY = 1;
    public static final int VERBOSITY_NONE = 0;
    final String accessToken;
    final URL collectorUrl;
    final Map<String, Object> tags;
    final long maxReportingIntervalMillis;
    final int maxBufferedSpans;
    final int verbosity;
    final boolean disableReportingLoop;
    final boolean resetClient;
    final boolean useClockCorrection;
    final ScopeManager scopeManager;
    final long deadlineMillis;

    private Options(String accessToken, URL collectorUrl, long maxReportingIntervalMillis, int maxBufferedSpans, int verbosity, boolean disableReportingLoop, boolean resetClient, Map<String, Object> tags, boolean useClockCorrection, ScopeManager scopeManager, long deadlineMillis) {
        this.accessToken = accessToken;
        this.collectorUrl = collectorUrl;
        this.maxReportingIntervalMillis = maxReportingIntervalMillis;
        this.maxBufferedSpans = maxBufferedSpans;
        this.verbosity = verbosity;
        this.disableReportingLoop = disableReportingLoop;
        this.resetClient = resetClient;
        this.tags = tags;
        this.useClockCorrection = useClockCorrection;
        this.scopeManager = scopeManager;
        this.deadlineMillis = deadlineMillis;
    }

    long getGuid() {
        return (Long)this.tags.get(GUID_KEY);
    }

    public Options setDefaultReportingIntervalMillis(int value) {
        if (this.maxReportingIntervalMillis != 3000L) {
            return this;
        }
        try {
            return new OptionsBuilder(this).withMaxReportingIntervalMillis(value).build();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Unexpected error when building a new set ofoptions from a valid set of existing options. collectorUrl=" + this.collectorUrl);
        }
    }

    public Options disableResetClient() {
        try {
            return new OptionsBuilder(this).withResetClient(false).build();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Unexpected error when building a new set ofoptions from a valid set of existing options. collectorUrl=" + this.collectorUrl);
        }
    }

    public static class OptionsBuilder {
        private String accessToken;
        private String collectorProtocol = "https";
        private String collectorHost = "collector-grpc.lightstep.com";
        private int collectorPort = -1;
        private long maxReportingIntervalMillis;
        private int maxBufferedSpans = -1;
        private int verbosity = 1;
        private boolean disableReportingLoop = false;
        private boolean resetClient = true;
        private boolean useClockCorrection = true;
        private Map<String, Object> tags = new HashMap<String, Object>();
        private ScopeManager scopeManager;
        private long deadlineMillis = -1L;

        public OptionsBuilder() {
        }

        public OptionsBuilder(Options options) {
            this.accessToken = options.accessToken;
            this.collectorProtocol = options.collectorUrl.getProtocol();
            this.collectorHost = options.collectorUrl.getHost();
            this.collectorPort = options.collectorUrl.getPort();
            this.maxReportingIntervalMillis = options.maxReportingIntervalMillis;
            this.maxBufferedSpans = options.maxBufferedSpans;
            this.verbosity = options.verbosity;
            this.disableReportingLoop = options.disableReportingLoop;
            this.resetClient = options.resetClient;
            this.tags = options.tags;
            this.scopeManager = options.scopeManager;
            this.useClockCorrection = options.useClockCorrection;
            this.deadlineMillis = options.deadlineMillis;
        }

        public OptionsBuilder withAccessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public OptionsBuilder withCollectorProtocol(String protocol) {
            if (!Options.HTTPS.equals(protocol) && !Options.HTTP.equals(protocol)) {
                throw new IllegalArgumentException("Invalid protocol for collector: " + protocol);
            }
            this.collectorProtocol = protocol;
            return this;
        }

        public OptionsBuilder withCollectorHost(String collectorHost) {
            if (collectorHost == null || "".equals(collectorHost.trim())) {
                throw new IllegalArgumentException("Invalid collector host: " + collectorHost);
            }
            this.collectorHost = collectorHost;
            return this;
        }

        public OptionsBuilder withCollectorPort(int collectorPort) {
            if (collectorPort <= 0) {
                throw new IllegalArgumentException("Invalid collector port: " + collectorPort);
            }
            this.collectorPort = collectorPort;
            return this;
        }

        public OptionsBuilder withComponentName(String name) {
            return this.withTag(Options.COMPONENT_NAME_KEY, name);
        }

        public OptionsBuilder withTag(String key, Object value) {
            this.tags.put(key, value);
            return this;
        }

        public OptionsBuilder withMaxReportingIntervalMillis(int maxReportingIntervalMillis) {
            this.maxReportingIntervalMillis = maxReportingIntervalMillis;
            return this;
        }

        public OptionsBuilder withMaxBufferedSpans(int maxBufferedSpans) {
            this.maxBufferedSpans = maxBufferedSpans;
            return this;
        }

        public OptionsBuilder withVerbosity(int verbosity) {
            this.verbosity = verbosity;
            return this;
        }

        public OptionsBuilder withDisableReportingLoop(boolean disable) {
            this.disableReportingLoop = disable;
            return this;
        }

        public OptionsBuilder withResetClient(boolean reset) {
            this.resetClient = reset;
            return this;
        }

        public OptionsBuilder withClockSkewCorrection(boolean clockCorrection) {
            this.useClockCorrection = clockCorrection;
            return this;
        }

        public Options build() throws MalformedURLException {
            this.defaultComponentName();
            this.defaultGuid();
            this.defaultMaxReportingIntervalMillis();
            this.defaultMaxBufferedSpans();
            this.defaultScopeManager();
            this.defaultDeadlineMillis();
            return new Options(this.accessToken, this.getCollectorUrl(), this.maxReportingIntervalMillis, this.maxBufferedSpans, this.verbosity, this.disableReportingLoop, this.resetClient, this.tags, this.useClockCorrection, this.scopeManager, this.deadlineMillis);
        }

        private void defaultScopeManager() {
            if (this.scopeManager == null) {
                this.scopeManager = new ThreadLocalScopeManager();
            }
        }

        private void defaultMaxReportingIntervalMillis() {
            if (this.maxReportingIntervalMillis <= 0L) {
                this.maxReportingIntervalMillis = 3000L;
            }
        }

        private void defaultMaxBufferedSpans() {
            if (this.maxBufferedSpans < 0) {
                this.maxBufferedSpans = 1000;
            }
        }

        private void defaultGuid() {
            if (this.tags.get(Options.GUID_KEY) == null) {
                this.withTag(Options.GUID_KEY, Util.generateRandomGUID());
            }
        }

        private void defaultComponentName() {
            StringTokenizer st;
            String componentNameSystemProperty;
            if (this.tags.get(Options.COMPONENT_NAME_KEY) == null && (componentNameSystemProperty = System.getProperty(Options.COMPONENT_NAME_SYSTEM_PROPERTY_KEY)) != null && (st = new StringTokenizer(componentNameSystemProperty)).hasMoreTokens()) {
                String name = st.nextToken();
                this.withComponentName(name);
                this.tags.put(Options.LEGACY_COMPONENT_NAME_KEY, name);
            }
        }

        private void defaultDeadlineMillis() {
            if (this.deadlineMillis < 0L) {
                this.deadlineMillis = 30000L;
            }
        }

        private int getPort() {
            if (this.collectorPort > 0) {
                return this.collectorPort;
            }
            if (this.collectorProtocol.equals(Options.HTTPS)) {
                return 443;
            }
            return 80;
        }

        private URL getCollectorUrl() throws MalformedURLException {
            int port = this.getPort();
            return new URL(this.collectorProtocol, this.collectorHost, port, Options.COLLECTOR_PATH);
        }
    }
}

