/*
 * Decompiled with CFR 0.152.
 */
package com.lightstep.tracer.shared;

import com.google.protobuf.ProtocolStringList;
import com.lightstep.tracer.grpc.Auth;
import com.lightstep.tracer.grpc.Command;
import com.lightstep.tracer.grpc.KeyValue;
import com.lightstep.tracer.grpc.ReportRequest;
import com.lightstep.tracer.grpc.ReportResponse;
import com.lightstep.tracer.grpc.Reporter;
import com.lightstep.tracer.grpc.Span;
import com.lightstep.tracer.shared.ClientMetrics;
import com.lightstep.tracer.shared.ClockState;
import com.lightstep.tracer.shared.CollectorClient;
import com.lightstep.tracer.shared.CollectorClientProvider;
import com.lightstep.tracer.shared.Options;
import com.lightstep.tracer.shared.Propagator;
import com.lightstep.tracer.shared.SimpleFuture;
import com.lightstep.tracer.shared.SpanBuilder;
import com.lightstep.tracer.shared.SpanContext;
import com.lightstep.tracer.shared.Status;
import com.lightstep.tracer.shared.Util;
import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AbstractTracer
implements Tracer {
    private static final long DEFAULT_CLOCK_STATE_INTERVAL_MILLIS = 500L;
    private static final int DEFAULT_CLIENT_RESET_INTERVAL_MILLIS = 300000;
    protected static final String LIGHTSTEP_TRACER_PLATFORM_KEY = "lightstep.tracer_platform";
    protected static final String LIGHTSTEP_TRACER_PLATFORM_VERSION_KEY = "lightstep.tracer_platform_version";
    protected static final String LIGHTSTEP_TRACER_VERSION_KEY = "lightstep.tracer_version";
    private final int verbosity;
    private final Auth.Builder auth;
    private final Reporter.Builder reporter;
    private final CollectorClient client;
    private final ClientMetrics clientMetrics;
    private boolean firstErrorLogged = false;
    private final AtomicLong lastNewSpanMillis;
    private ArrayList<Span> spans;
    private final ClockState clockState;
    protected final Object mutex = new Object();
    private boolean reportInProgress;
    private ReportingLoop reportingLoop;
    private final int maxBufferedSpans;
    private Thread reportingThread;
    private boolean isDisabled;
    private boolean resetClient;
    private final ScopeManager scopeManager;

    public AbstractTracer(Options options) {
        this.scopeManager = options.scopeManager;
        this.verbosity = options.verbosity;
        this.maxBufferedSpans = options.maxBufferedSpans;
        this.lastNewSpanMillis = new AtomicLong(System.currentTimeMillis());
        this.spans = new ArrayList(this.maxBufferedSpans);
        this.clockState = options.useClockCorrection ? new ClockState() : new ClockState.NoopClockState();
        this.auth = Auth.newBuilder().setAccessToken(options.accessToken);
        this.reporter = Reporter.newBuilder().setReporterId(options.getGuid());
        this.resetClient = options.resetClient;
        this.clientMetrics = new ClientMetrics();
        boolean validCollectorClient = true;
        this.client = CollectorClientProvider.provider().forOptions(this, options);
        if (this.client == null) {
            this.error("Exception creating client.");
            validCollectorClient = false;
            this.disable();
        }
        for (Map.Entry<String, Object> entry : options.tags.entrySet()) {
            this.addTracerTag(entry.getKey(), entry.getValue());
        }
        if (validCollectorClient && !options.disableReportingLoop) {
            this.reportingLoop = new ReportingLoop(options.maxReportingIntervalMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStopReporting() {
        AbstractTracer abstractTracer = this;
        synchronized (abstractTracer) {
            if (this.reportingThread == null) {
                return;
            }
            this.reportingThread.interrupt();
            this.reportingThread = null;
        }
    }

    private void maybeStartReporting() {
        if (this.reportingThread != null) {
            return;
        }
        this.reportingThread = new Thread(this.reportingLoop);
        this.reportingThread.setDaemon(true);
        this.reportingThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disable() {
        this.info("Disabling client library");
        this.doStopReporting();
        Object object = this.mutex;
        synchronized (object) {
            if (this.client != null) {
                this.client.shutdown();
            }
            this.isDisabled = true;
            this.spans = new ArrayList(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisabled() {
        Object object = this.mutex;
        synchronized (object) {
            return this.isDisabled;
        }
    }

    public ScopeManager scopeManager() {
        return this.scopeManager;
    }

    public io.opentracing.Span activeSpan() {
        Scope scope = this.scopeManager.active();
        return scope == null ? null : scope.span();
    }

    public Tracer.SpanBuilder buildSpan(String operationName) {
        return new SpanBuilder(operationName, this);
    }

    public <C> void inject(io.opentracing.SpanContext spanContext, Format<C> format, C carrier) {
        if (!(spanContext instanceof SpanContext)) {
            this.error("Unsupported SpanContext implementation: " + spanContext.getClass());
            return;
        }
        SpanContext lightstepSpanContext = (SpanContext)spanContext;
        if (format == Format.Builtin.TEXT_MAP) {
            Propagator.TEXT_MAP.inject(lightstepSpanContext, (TextMap)carrier);
        } else if (format == Format.Builtin.HTTP_HEADERS) {
            Propagator.HTTP_HEADERS.inject(lightstepSpanContext, (TextMap)carrier);
        } else if (format == Format.Builtin.BINARY) {
            this.warn("LightStep-java does not yet support binary carriers. SpanContext: " + spanContext.toString());
            Propagator.BINARY.inject(lightstepSpanContext, (ByteBuffer)carrier);
        } else {
            this.info("Unsupported carrier type: " + carrier.getClass());
        }
    }

    public <C> io.opentracing.SpanContext extract(Format<C> format, C carrier) {
        if (format == Format.Builtin.TEXT_MAP) {
            return Propagator.TEXT_MAP.extract((TextMap)carrier);
        }
        if (format == Format.Builtin.HTTP_HEADERS) {
            return Propagator.HTTP_HEADERS.extract((TextMap)carrier);
        }
        if (format == Format.Builtin.BINARY) {
            this.warn("LightStep-java does not yet support binary carriers.");
            return Propagator.BINARY.extract((ByteBuffer)carrier);
        }
        this.info("Unsupported carrier type: " + carrier.getClass());
        return null;
    }

    public Boolean flush(long timeoutMillis) {
        SimpleFuture<Boolean> flushFuture = this.flushInternal(true);
        try {
            return flushFuture.getWithTimeout(timeoutMillis);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    protected abstract SimpleFuture<Boolean> flushInternal(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean sendReport(boolean explicitRequest) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.reportInProgress) {
                this.debug("Report in progress. Skipping.");
                return true;
            }
            if (this.spans.size() == 0 && this.clockState.isReady()) {
                this.debug("Skipping report. No new data.");
                return true;
            }
            this.reportInProgress = true;
        }
        try {
            ReportResult result = this.sendReportWorker(explicitRequest);
            this.clientMetrics.addSpansDropped(result.getDroppedSpans());
            boolean bl = result.wasSuccessful();
            return bl;
        }
        finally {
            Object object2 = this.mutex;
            synchronized (object2) {
                this.reportInProgress = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int unreportedSpanCount() {
        Object object = this.mutex;
        synchronized (object) {
            return this.spans.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReportResult sendReportWorker(boolean explicitRequest) {
        ArrayList<Span> spans;
        Object object = this.mutex;
        synchronized (object) {
            if (this.clockState.isReady() || explicitRequest) {
                spans = this.spans;
                this.spans = new ArrayList(this.maxBufferedSpans);
                this.debug(String.format("Sending report, %d spans", spans.size()));
            } else {
                this.debug("Sending empty report to prime clock state");
                spans = new ArrayList();
            }
        }
        ReportRequest request = ReportRequest.newBuilder().setReporter(this.reporter).setAuth(this.auth).addAllSpans(spans).setTimestampOffsetMicros(Util.safeLongToInt(this.clockState.offsetMicros())).setInternalMetrics(this.clientMetrics.toInternalMetricsAndReset()).build();
        long originMicros = Util.nowMicrosApproximate();
        long originRelativeNanos = System.nanoTime();
        ReportResponse response = null;
        if (this.client != null) {
            response = this.client.report(request);
        }
        if (response == null) {
            return ReportResult.Error(spans.size());
        }
        if (!response.getErrorsList().isEmpty()) {
            ProtocolStringList errs = response.getErrorsList();
            for (String err : errs) {
                this.error("Collector response contained error: ", err);
            }
            return ReportResult.Error(spans.size());
        }
        if (response.hasReceiveTimestamp() && response.hasTransmitTimestamp()) {
            long deltaMicros = (System.nanoTime() - originRelativeNanos) / 1000L;
            long destinationMicros = originMicros + deltaMicros;
            this.clockState.addSample(originMicros, Util.protoTimeToEpochMicros(response.getReceiveTimestamp()), Util.protoTimeToEpochMicros(response.getTransmitTimestamp()), destinationMicros);
        } else {
            this.warn("Collector response did not include timing info");
        }
        if (response.getCommandsCount() != 0) {
            for (Command command : response.getCommandsList()) {
                if (!command.getDisable()) continue;
                this.disable();
            }
        }
        this.debug(String.format("Report sent successfully (%d spans)", spans.size()));
        return ReportResult.Success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSpan(Span span) {
        this.lastNewSpanMillis.set(System.currentTimeMillis());
        Object object = this.mutex;
        synchronized (object) {
            if (this.spans.size() >= this.maxBufferedSpans) {
                this.clientMetrics.addSpansDropped(1);
            } else {
                this.spans.add(span);
            }
            this.maybeStartReporting();
        }
    }

    protected void addTracerTag(String key, Object value) {
        this.debug("Adding tracer tag: " + key + " => " + value);
        if (value instanceof String) {
            this.reporter.addTags(KeyValue.newBuilder().setKey(key).setStringValue((String)value));
        } else if (value instanceof Boolean) {
            this.reporter.addTags(KeyValue.newBuilder().setKey(key).setBoolValue((Boolean)value));
        } else if (value instanceof Number) {
            if (value instanceof Long || value instanceof Integer) {
                this.reporter.addTags(KeyValue.newBuilder().setKey(key).setIntValue(((Number)value).longValue()));
            } else if (value instanceof Double || value instanceof Float) {
                this.reporter.addTags(KeyValue.newBuilder().setKey(key).setDoubleValue(((Number)value).doubleValue()));
            } else {
                this.reporter.addTags(KeyValue.newBuilder().setKey(key).setStringValue(value.toString()));
            }
        } else {
            this.reporter.addTags(KeyValue.newBuilder().setKey(key).setStringValue(value.toString()));
        }
    }

    protected void debug(String s) {
        this.debug(s, null);
    }

    protected void debug(String msg, Object payload) {
        if (this.verbosity < 4) {
            return;
        }
        this.printLogToConsole(InternalLogLevel.DEBUG, msg, payload);
    }

    protected void info(String s) {
        this.info(s, null);
    }

    protected void info(String msg, Object payload) {
        if (this.verbosity < 3) {
            return;
        }
        this.printLogToConsole(InternalLogLevel.INFO, msg, payload);
    }

    protected void warn(String s) {
        this.warn(s, null);
    }

    protected void warn(String msg, Object payload) {
        if (this.verbosity < 3) {
            return;
        }
        this.printLogToConsole(InternalLogLevel.WARN, msg, payload);
    }

    protected void error(String s) {
        this.error(s, null);
    }

    protected void error(String msg, Object payload) {
        if (this.verbosity < 1) {
            return;
        }
        if (this.verbosity == 1 && this.firstErrorLogged) {
            return;
        }
        this.firstErrorLogged = true;
        this.printLogToConsole(InternalLogLevel.ERROR, msg, payload);
    }

    protected abstract void printLogToConsole(InternalLogLevel var1, String var2, Object var3);

    String generateTraceURL(long spanId) {
        return "https://app.lightstep.com/" + this.auth.getAccessToken() + "/trace?span_guid=" + Long.toHexString(spanId) + "&at_micros=" + Util.nowMicrosApproximate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status status() {
        Object object = this.mutex;
        synchronized (object) {
            long spansDropped = 0L;
            if (this.client != null) {
                spansDropped = this.clientMetrics.getSpansDropped();
            }
            return new Status(this.reporter.getTagsList(), spansDropped);
        }
    }

    private class ReportingLoop
    implements Runnable {
        private static final int POLL_INTERVAL_MILLIS = 40;
        private static final int THREAD_TIMEOUT_MILLIS = 2000;
        private Random rng = new Random(System.currentTimeMillis());
        private long reportingIntervalMillis = 0L;
        private int consecutiveFailures = 0;

        ReportingLoop(long interval) {
            this.reportingIntervalMillis = interval;
        }

        @Override
        public void run() {
            AbstractTracer.this.debug("Reporting thread started");
            long nextReportMillis = this.computeNextReportMillis();
            long nextResetMillis = System.currentTimeMillis() + 300000L;
            while (!Thread.interrupted()) {
                long nowMillis = System.currentTimeMillis();
                if (AbstractTracer.this.resetClient && nowMillis >= nextResetMillis) {
                    AbstractTracer.this.client.reconnect();
                    nextResetMillis = System.currentTimeMillis() + 300000L;
                }
                if (AbstractTracer.this.spans.size() >= AbstractTracer.this.maxBufferedSpans / 2 || nowMillis >= nextReportMillis) {
                    SimpleFuture<Boolean> result = AbstractTracer.this.flushInternal(false);
                    boolean reportSucceeded = false;
                    try {
                        reportSucceeded = result.get();
                    }
                    catch (InterruptedException e) {
                        AbstractTracer.this.warn("Future timed out");
                        Thread.currentThread().interrupt();
                    }
                    this.consecutiveFailures = !reportSucceeded ? ++this.consecutiveFailures : 0;
                    nextReportMillis = this.computeNextReportMillis();
                }
                boolean hasUnreportedSpans = AbstractTracer.this.unreportedSpanCount() > 0;
                long lastSpanAgeMillis = System.currentTimeMillis() - AbstractTracer.this.lastNewSpanMillis.get();
                if (!(hasUnreportedSpans && this.consecutiveFailures < 2 || lastSpanAgeMillis <= 2000L)) {
                    AbstractTracer.this.doStopReporting();
                    continue;
                }
                try {
                    Thread.sleep(40L);
                }
                catch (InterruptedException e) {
                    AbstractTracer.this.warn("Exception trying to sleep in reporting thread");
                    Thread.currentThread().interrupt();
                }
            }
            AbstractTracer.this.debug("Reporting thread stopped");
        }

        long computeNextReportMillis() {
            double base = !AbstractTracer.this.clockState.isReady() ? 500.0 : (double)this.reportingIntervalMillis;
            int backOff = 1 + Math.min(7, this.consecutiveFailures);
            double delta = (base *= (double)backOff) * (0.9 + 0.2 * this.rng.nextDouble());
            long nextMillis = System.currentTimeMillis() + (long)Math.ceil(delta);
            AbstractTracer.this.debug(String.format("Next report: %d (%f) [%d]", nextMillis, delta, AbstractTracer.this.clockState.activeSampleCount()));
            return nextMillis;
        }
    }

    protected static enum InternalLogLevel {
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }

    private static class ReportResult {
        private final int droppedSpans;
        private final boolean success;

        private ReportResult(int droppedSpans, boolean success) {
            this.droppedSpans = droppedSpans;
            this.success = success;
        }

        public static ReportResult Success() {
            return new ReportResult(0, true);
        }

        public static ReportResult Error(int droppedSpans) {
            return new ReportResult(droppedSpans, false);
        }

        public int getDroppedSpans() {
            return this.droppedSpans;
        }

        public boolean wasSuccessful() {
            return this.success;
        }
    }
}

