/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.util;

import com.couchbase.client.core.annotation.Stability;

public class Coordinate {
    private final double lon;
    private final double lat;

    public static Coordinate ofLonLat(double lon, double lat) {
        return new Coordinate(lon, lat);
    }

    private Coordinate(double lon, double lat) {
        this.lon = lon;
        this.lat = lat;
    }

    public double lon() {
        return this.lon;
    }

    public double lat() {
        return this.lat;
    }

    @Stability.Uncommitted
    public static CoordinateBuilderLatitude lat(double lat) {
        return new CoordinateBuilderLatitude(lat);
    }

    @Stability.Uncommitted
    public static CoordinateBuilderLongitude lon(double lon) {
        return new CoordinateBuilderLongitude(lon);
    }

    public String toString() {
        return "Coordinate{lon=" + this.lon + ", lat=" + this.lat + '}';
    }

    public static final class CoordinateBuilderLongitude {
        private final double lon;

        private CoordinateBuilderLongitude(double lon) {
            this.lon = lon;
        }

        public Coordinate lat(double lat) {
            return new Coordinate(this.lon, lat);
        }
    }

    public static final class CoordinateBuilderLatitude {
        private final double lat;

        private CoordinateBuilderLatitude(double lat) {
            this.lat = lat;
        }

        public Coordinate lon(double lon) {
            return new Coordinate(lon, this.lat);
        }
    }
}

