/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.kv;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.kv.CoreScanTerm;
import com.couchbase.client.core.util.CbStrings;
import com.couchbase.client.core.util.Validators;

@Stability.Volatile
public class ScanTerm {
    private static final ScanTerm MINIMUM = ScanTerm.inclusive(CbStrings.MIN_CODE_POINT_AS_STRING);
    private static final ScanTerm MAXIMUM = ScanTerm.inclusive(CbStrings.MAX_CODE_POINT_AS_STRING);
    private final String id;
    private final boolean exclusive;

    private ScanTerm(String id, boolean exclusive) {
        this.id = Validators.notNullOrEmpty((String)id, (String)"ScanTerm ID");
        this.exclusive = exclusive;
    }

    public String id() {
        return this.id;
    }

    public boolean exclusive() {
        return this.exclusive;
    }

    public static ScanTerm inclusive(String id) {
        return new ScanTerm(id, false);
    }

    public static ScanTerm exclusive(String id) {
        return new ScanTerm(id, true);
    }

    public static ScanTerm minimum() {
        return MINIMUM;
    }

    public static ScanTerm maximum() {
        return MAXIMUM;
    }

    @Stability.Internal
    public CoreScanTerm toCore() {
        return new CoreScanTerm(this.id, this.exclusive);
    }
}

