/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java;

import com.couchbase.client.core.CoreKeyspace;
import com.couchbase.client.core.api.CoreCouchbaseOps;
import com.couchbase.client.core.api.kv.CoreKvBinaryOps;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.error.context.ReducedKeyValueErrorContext;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.BinaryCollection;
import com.couchbase.client.java.kv.AppendOptions;
import com.couchbase.client.java.kv.CounterResult;
import com.couchbase.client.java.kv.DecrementOptions;
import com.couchbase.client.java.kv.IncrementOptions;
import com.couchbase.client.java.kv.MutationResult;
import com.couchbase.client.java.kv.PrependOptions;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class AsyncBinaryCollection {
    final CoreKvBinaryOps coreKvBinaryOps;
    private final CoreKeyspace keyspace;

    AsyncBinaryCollection(CoreKeyspace keyspace, CoreCouchbaseOps couchbaseOps) {
        this.keyspace = Objects.requireNonNull(keyspace);
        this.coreKvBinaryOps = couchbaseOps.kvBinaryOps(keyspace);
    }

    public CompletableFuture<MutationResult> append(String id, byte[] content) {
        return this.append(id, content, BinaryCollection.DEFAULT_APPEND_OPTIONS);
    }

    public CompletableFuture<MutationResult> append(String id, byte[] content, AppendOptions options) {
        Validators.notNull((Object)options, (String)"AppendOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier()));
        AppendOptions.Built opts = ((AppendOptions)Validators.notNull((Object)options, (String)"options")).build();
        return this.coreKvBinaryOps.appendAsync(id, content, (CoreCommonOptions)opts, opts.cas(), opts.toCoreDurability()).thenApply(MutationResult::new);
    }

    public CompletableFuture<MutationResult> prepend(String id, byte[] content) {
        return this.prepend(id, content, BinaryCollection.DEFAULT_PREPEND_OPTIONS);
    }

    public CompletableFuture<MutationResult> prepend(String id, byte[] content, PrependOptions options) {
        Validators.notNull((Object)options, (String)"PrependOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier()));
        PrependOptions.Built opts = options.build();
        return this.coreKvBinaryOps.prependAsync(id, content, (CoreCommonOptions)opts, opts.cas(), opts.toCoreDurability()).thenApply(MutationResult::new);
    }

    public CompletableFuture<CounterResult> increment(String id) {
        return this.increment(id, BinaryCollection.DEFAULT_INCREMENT_OPTIONS);
    }

    public CompletableFuture<CounterResult> increment(String id, IncrementOptions options) {
        Validators.notNull((Object)options, (String)"IncrementOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier()));
        IncrementOptions.Built opts = options.build();
        return this.coreKvBinaryOps.incrementAsync(id, (CoreCommonOptions)opts, opts.expiry().encode(), opts.delta(), opts.initial(), opts.toCoreDurability()).thenApply(CounterResult::new);
    }

    public CompletableFuture<CounterResult> decrement(String id) {
        return this.decrement(id, BinaryCollection.DEFAULT_DECREMENT_OPTIONS);
    }

    public CompletableFuture<CounterResult> decrement(String id, DecrementOptions options) {
        Validators.notNull((Object)options, (String)"DecrementOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier()));
        DecrementOptions.Built opts = options.build();
        return this.coreKvBinaryOps.decrementAsync(id, (CoreCommonOptions)opts, opts.expiry().encode(), opts.delta(), opts.initial(), opts.toCoreDurability()).thenApply(CounterResult::new);
    }

    CollectionIdentifier collectionIdentifier() {
        return this.keyspace.toCollectionIdentifier();
    }
}

