/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.CommonOptions;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.kv.MutationState;
import com.couchbase.client.java.search.HighlightStyle;
import com.couchbase.client.java.search.SearchScanConsistency;
import com.couchbase.client.java.search.facet.SearchFacet;
import com.couchbase.client.java.search.sort.SearchSort;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;

public class SearchOptions
extends CommonOptions<SearchOptions> {
    private String[] collections;
    private SearchScanConsistency consistency;
    private MutationState consistentWith;
    private boolean disableScoring = false;
    private Boolean explain;
    private Map<String, SearchFacet> facets;
    private String[] fields;
    private String[] highlightFields;
    private HighlightStyle highlightStyle;
    private Integer limit;
    private Map<String, Object> raw;
    private JsonSerializer serializer;
    private Integer skip;
    private JsonArray sort;
    private boolean includeLocations = false;

    public static SearchOptions searchOptions() {
        return new SearchOptions();
    }

    private SearchOptions() {
    }

    public SearchOptions raw(String key, Object value) {
        Validators.notNullOrEmpty((String)key, (String)"Key");
        if (this.raw == null) {
            this.raw = new HashMap<String, Object>();
        }
        this.raw.put(key, value);
        return this;
    }

    public SearchOptions limit(int limit) {
        this.limit = limit;
        return this;
    }

    public SearchOptions skip(int skip) {
        this.skip = skip;
        return this;
    }

    public SearchOptions explain(boolean explain) {
        this.explain = explain;
        return this;
    }

    public SearchOptions highlight(HighlightStyle style, String ... fields) {
        this.highlightStyle = style;
        if (fields != null && fields.length > 0) {
            this.highlightFields = fields;
        }
        return this;
    }

    public SearchOptions highlight(String ... fields) {
        return this.highlight(HighlightStyle.SERVER_DEFAULT, fields);
    }

    public SearchOptions highlight() {
        return this.highlight(HighlightStyle.SERVER_DEFAULT, new String[0]);
    }

    public SearchOptions fields(String ... fields) {
        if (fields != null) {
            this.fields = fields;
        }
        return this;
    }

    public SearchOptions collections(String ... collectionNames) {
        if (collectionNames != null) {
            this.collections = collectionNames;
        }
        return this;
    }

    public SearchOptions scanConsistency(SearchScanConsistency consistency) {
        this.consistency = consistency;
        this.consistentWith = null;
        return this;
    }

    public SearchOptions consistentWith(MutationState consistentWith) {
        this.consistentWith = consistentWith;
        this.consistency = null;
        return this;
    }

    public SearchOptions sort(Object ... sort) {
        if (this.sort == null) {
            this.sort = JsonArray.create();
        }
        if (sort != null) {
            for (Object o : sort) {
                if (o instanceof String) {
                    this.sort.add((String)o);
                    continue;
                }
                if (o instanceof SearchSort) {
                    JsonObject params = JsonObject.create();
                    ((SearchSort)o).injectParams(params);
                    this.sort.add(params);
                    continue;
                }
                throw InvalidArgumentException.fromMessage((String)"Only String or SearchSort instances are allowed as sort arguments!");
            }
        }
        return this;
    }

    public SearchOptions facets(Map<String, SearchFacet> facets) {
        this.facets = facets;
        return this;
    }

    public SearchOptions serializer(JsonSerializer serializer) {
        this.serializer = serializer;
        return this;
    }

    public SearchOptions disableScoring(boolean disableScoring) {
        this.disableScoring = disableScoring;
        return this;
    }

    public SearchOptions includeLocations(boolean includeLocations) {
        this.includeLocations = includeLocations;
        return this;
    }

    @Stability.Internal
    public Built build() {
        return new Built();
    }

    public class Built
    extends CommonOptions.BuiltCommonOptions {
        Built() {
        }

        public JsonSerializer serializer() {
            return SearchOptions.this.serializer;
        }

        @Stability.Internal
        public void injectParams(String indexName, JsonObject queryJson, Duration timeout) {
            JsonObject consistencyJson;
            if (SearchOptions.this.limit != null && SearchOptions.this.limit >= 0) {
                queryJson.put("size", SearchOptions.this.limit);
            }
            if (SearchOptions.this.skip != null && SearchOptions.this.skip >= 0) {
                queryJson.put("from", SearchOptions.this.skip);
            }
            if (SearchOptions.this.explain != null) {
                queryJson.put("explain", SearchOptions.this.explain);
            }
            if (SearchOptions.this.highlightStyle != null) {
                JsonObject highlight = JsonObject.create();
                if (SearchOptions.this.highlightStyle != HighlightStyle.SERVER_DEFAULT) {
                    highlight.put("style", SearchOptions.this.highlightStyle.name().toLowerCase());
                }
                if (SearchOptions.this.highlightFields != null && SearchOptions.this.highlightFields.length > 0) {
                    highlight.put("fields", JsonArray.from(SearchOptions.this.highlightFields));
                }
                queryJson.put("highlight", highlight);
            }
            if (SearchOptions.this.fields != null && SearchOptions.this.fields.length > 0) {
                queryJson.put("fields", JsonArray.from(SearchOptions.this.fields));
            }
            if (SearchOptions.this.sort != null && !SearchOptions.this.sort.isEmpty()) {
                queryJson.put("sort", SearchOptions.this.sort);
            }
            if (SearchOptions.this.disableScoring) {
                queryJson.put("score", "none");
            }
            if (SearchOptions.this.facets != null && !SearchOptions.this.facets.isEmpty()) {
                JsonObject f = JsonObject.create();
                for (Map.Entry entry : SearchOptions.this.facets.entrySet()) {
                    JsonObject facetJson = JsonObject.create();
                    ((SearchFacet)entry.getValue()).injectParams(facetJson);
                    f.put((String)entry.getKey(), facetJson);
                }
                queryJson.put("facets", f);
            }
            JsonObject control = JsonObject.create();
            control.put("timeout", timeout.toMillis());
            if (SearchOptions.this.consistency != null && SearchOptions.this.consistency != SearchScanConsistency.NOT_BOUNDED) {
                consistencyJson = JsonObject.create();
                consistencyJson.put("level", SearchOptions.this.consistency.toString());
                control.put("consistency", consistencyJson);
            }
            if (SearchOptions.this.consistentWith != null) {
                consistencyJson = JsonObject.create();
                consistencyJson.put("level", "at_plus");
                consistencyJson.put("vectors", JsonObject.create().put(indexName, SearchOptions.this.consistentWith.exportForSearch()));
                control.put("consistency", consistencyJson);
            }
            if (!control.isEmpty()) {
                queryJson.put("ctl", control);
            }
            if (SearchOptions.this.collections != null && SearchOptions.this.collections.length > 0) {
                queryJson.put("collections", JsonArray.from(SearchOptions.this.collections));
            }
            if (SearchOptions.this.includeLocations) {
                queryJson.put("includeLocations", true);
            }
            if (SearchOptions.this.raw != null) {
                for (Map.Entry entry : SearchOptions.this.raw.entrySet()) {
                    queryJson.put((String)entry.getKey(), entry.getValue());
                }
            }
        }
    }
}

